/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.adventurez.block.PiglinFlag;
import net.adventurez.block.entity.PiglinFlagEntity;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@Environment(value=EnvType.CLIENT)
public class PiglinFlagRenderer
implements BlockEntityRenderer<PiglinFlagEntity> {
    private final ModelPart flag;
    private final ModelPart holder;

    public PiglinFlagRenderer(BlockEntityRendererProvider.Context ctx) {
        this.holder = ctx.m_173582_(RenderInit.PIGLIN_FLAG_LAYER).m_171324_("holder");
        this.flag = this.holder.m_171324_("flag");
    }

    public PiglinFlagRenderer(ModelPart root) {
        this.holder = root.m_171324_("holder");
        this.flag = this.holder.m_171324_("flag");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData1 = modelPartData.m_171599_("holder", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-2.0f, -11.0f, -2.0f, 4.0f, 11.0f, 4.0f).m_171514_(10, 20).m_171481_(-2.0f, -44.0f, -2.0f, 4.0f, 4.0f, 18.0f).m_171514_(36, 0).m_171481_(-1.0f, -40.0f, -1.0f, 2.0f, 29.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        modelPartData1.m_171599_("flag", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, -6.6f, 0.0f, 24.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)-40.0f, (float)8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void render(PiglinFlagEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        matrices.m_85836_();
        int lightAbove = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_().m_7494_());
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)new ResourceLocation("adventurez:textures/block/piglin_flag.png")));
        BlockState state = entity.m_58900_();
        Direction blockDirection = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (state.m_60734_() instanceof PiglinFlag) {
            if (blockDirection.equals((Object)Direction.NORTH)) {
                matrices.m_85837_(1.0, 0.0, 1.0);
                matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            } else if (blockDirection.equals((Object)Direction.EAST)) {
                matrices.m_85837_(0.0, 0.0, 1.0);
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            } else if (!blockDirection.equals((Object)Direction.SOUTH) && blockDirection.equals((Object)Direction.WEST)) {
                matrices.m_85837_(1.0, 0.0, 0.0);
                matrices.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            }
        }
        matrices.m_85841_(1.0f, -1.0f, 1.0f);
        matrices.m_85837_(0.5, -1.5, 0.5);
        BlockPos blockPos = entity.m_58899_();
        long worldTime = entity.m_58904_().m_46467_();
        float goodFloat = ((float)Math.floorMod((long)(blockPos.m_123341_() * 7 + blockPos.m_123342_() * 9 + blockPos.m_123343_() * 13) + worldTime, 100L) + tickDelta) / 100.0f;
        this.flag.f_104205_ = Mth.m_14089_((float)((float)Math.PI * 2 * goodFloat)) / 4.0f;
        this.holder.m_104306_(matrices, vertexConsumer, lightAbove, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.m_85849_();
    }
}

